package com.ejie.ab04b.service;

import com.ejie.ab04b.dao.TipoAperturaDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TipoApertura;

/**
 * TipoAperturaServiceImpl generated by UDA, 27-dic-2016 9:57:25.
 * 
 * @author UDA
 */

@Service(value = "tipoAperturaService")
public class TipoAperturaServiceImpl implements TipoAperturaService {

	@Autowired
	private TipoAperturaDao tipoAperturaDao;

	/**
	 * Inserts a single row in the Ab04b71s00 table.
	 * 
	 *  tipoApertura
	 *            TipoApertura
	 *  TipoApertura
	 *
	 * @param tipoApertura the tipo apertura
	 * @return the tipo apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoApertura add(TipoApertura tipoApertura) {
		return this.tipoAperturaDao.add(tipoApertura);
	}

	/**
	 * Updates a single row in the Ab04b71s00 table.
	 * 
	 *  tipoApertura
	 *            TipoApertura
	 *  TipoApertura
	 *
	 * @param tipoApertura the tipo apertura
	 * @return the tipo apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoApertura update(TipoApertura tipoApertura) {
		return this.tipoAperturaDao.update(tipoApertura);
	}

	/**
	 * Finds a single row in the Ab04b71s00 table.
	 * 
	 *  tipoApertura
	 *            TipoApertura
	 *  TipoApertura
	 *
	 * @param tipoApertura the tipo apertura
	 * @return the tipo apertura
	 */
	public TipoApertura find(TipoApertura tipoApertura) {
		return (TipoApertura) this.tipoAperturaDao.find(tipoApertura);
	}

	/**
	 * Deletes a single row in the Ab04b71s00 table.
	 * 
	 *  tipoApertura
	 *            TipoApertura
	 *
	 * @param tipoApertura the tipo apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoApertura tipoApertura) {
		this.tipoAperturaDao.remove(tipoApertura);
	}

	/**
	 * Finds a list of rows in the Ab04b71s00 table.
	 * 
	 *  tipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TipoApertura>
	 *
	 * @param tipoApertura the tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TipoApertura> findAll(TipoApertura tipoApertura,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TipoApertura>) this.tipoAperturaDao.findAll(tipoApertura,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b71s00 table using like.
	 * 
	 *  tipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TipoApertura>
	 *
	 * @param tipoApertura the tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TipoApertura> findAllLike(TipoApertura tipoApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TipoApertura>) this.tipoAperturaDao.findAllLike(
				tipoApertura, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b71s00 table.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(TipoApertura filterTipoApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.tipoAperturaDao.removeMultiple(filterTipoApertura,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b71s00 table.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab04b71s00>
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TipoApertura> filter(
			TipoApertura filterTipoApertura, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<TipoApertura> listaTipoApertura = this.tipoAperturaDao
				.findAllLike(filterTipoApertura, jqGridRequestDto, false);
		Long recordNum = this.tipoAperturaDao.findAllLikeCount(
				filterTipoApertura != null ? filterTipoApertura
						: new TipoApertura(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TipoApertura>> reorderSelection = this.tipoAperturaDao
					.reorderSelection(filterTipoApertura, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TipoApertura>(jqGridRequestDto,
					recordNum, listaTipoApertura, reorderSelection);
		}
		return new JQGridResponseDto<TipoApertura>(jqGridRequestDto, recordNum,
				listaTipoApertura);
	}

	/**
	 * Searches rows in the Ab04b71s00 table.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura
	 *  searchTipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab04b71s00>>
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param searchTipoApertura the search tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TipoApertura>> search(
			TipoApertura filterTipoApertura, TipoApertura searchTipoApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoAperturaDao.search(filterTipoApertura,
				searchTipoApertura, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b71s00 table.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TipoApertura filterTipoApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoAperturaDao.reorderSelection(filterTipoApertura,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab04b71s00 table.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<TipoApertura>>
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<TipoApertura>> jerarquia(
			TipoApertura filterTipoApertura, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<TipoApertura>> listaTipoApertura = this.tipoAperturaDao
				.findAllLikeJerarquia(filterTipoApertura, jqGridRequestDto);
		Long recordNum = this.tipoAperturaDao.findAllLikeCountJerarquia(
				filterTipoApertura, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<TipoApertura>>(
				jqGridRequestDto, recordNum, listaTipoApertura);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab04b71s00 table.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<TipoApertura>>
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<TipoApertura>> jerarquiaChildren(
			TipoApertura filterTipoApertura, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<TipoApertura>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<TipoApertura>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.tipoAperturaDao.findAllChild(filterTipoApertura,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
